using System;
using ANTIBODYPARAMETER = gov.va.med.vbecs.Common.VbecsTables.AntibodyParameter;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/9/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Antibody parameter business object layer class</summary>

	#endregion

	public class AntibodyParameter : BaseBusinessObject
	{

		#region Constructors

		System.Data.DataTable _dtAntibodyParameter;
		System.Data.DataRow _drAntibodyParameter;

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2197"> 
		///		<ExpectedInput>AntibodyTypeId</ExpectedInput>
		///		<ExpectedOutput>AntibodyParameter object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2198"> 
		///		<ExpectedInput>Invalid AntibodyTypeId</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntibodyParameter
		/// </summary>
		/// <param name="antibodyTypeID"></param>
		public AntibodyParameter(int antibodyTypeID)
		{

			this._dtAntibodyParameter = DAL.AntibodyType.GetAntibodyParameterById(antibodyTypeID);

			if (this._dtAntibodyParameter.Rows.Count == 0)
			{
				throw new ArgumentException("Antibody not found");
			}
			else
			{
				this._drAntibodyParameter = this._dtAntibodyParameter.Rows[0];
				this.IsNew = false;
			}
		}

		#endregion


		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2199"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2200"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntibodyParameterGuid
		/// </summary>
		public System.Guid AntibodyParameterGuid
		{
			get
			{
				return (System.Guid)this._drAntibodyParameter[ANTIBODYPARAMETER.AntibodyParameterGuid];
			}
			set
			{
				this._drAntibodyParameter[ANTIBODYPARAMETER.AntibodyParameterGuid] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2201"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2202"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntibodyTypeId
		/// </summary>
		public int AntibodyTypeId
		{
			get
			{
				return (int)this._drAntibodyParameter[ANTIBODYPARAMETER.AntibodyTypeId];
			}
			set
			{
				this._drAntibodyParameter[ANTIBODYPARAMETER.AntibodyTypeId] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2203"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2204"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// HigherLevelOverrideIndicator
		/// </summary>
		public bool HigherLevelOverrideIndicator
		{
			get
			{
				return (bool)this._drAntibodyParameter[ANTIBODYPARAMETER.HigherLevelOverrideIndicator];
			}
			set
			{
				this._drAntibodyParameter[ANTIBODYPARAMETER.HigherLevelOverrideIndicator] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2206"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2207"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// CanChangeIndicator
		/// </summary>
		public bool CanChangeIndicator
		{
			get
			{
				return (bool)this._drAntibodyParameter[ANTIBODYPARAMETER.CanChangeIndicator];
			}
			set
			{
				this._drAntibodyParameter[ANTIBODYPARAMETER.CanChangeIndicator] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2208"> 
		///		<ExpectedInput>int</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2210"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// CompatibilityPercentage
		/// </summary>
		public int CompatibilityPercentage
		{
			get
			{
				return System.Convert.ToInt16(this._drAntibodyParameter[ANTIBODYPARAMETER.CompatibilityPercentage]);
			}
			set
			{
				this._drAntibodyParameter[ANTIBODYPARAMETER.CompatibilityPercentage] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2211"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>division</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2212"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DivisionCode
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._drAntibodyParameter[ANTIBODYPARAMETER.DivisionCode].ToString().Trim();
			}
		}

		#endregion


		#region Methods



		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2226"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2249"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(ANTIBODYPARAMETER.AntibodyParameterGuid))
			{
				dtRow[ANTIBODYPARAMETER.AntibodyParameterGuid] = this.AntibodyParameterGuid;
			}

			if (dtRow.Table.Columns.Contains(ANTIBODYPARAMETER.AntibodyTypeId))
			{
				dtRow[ANTIBODYPARAMETER.AntibodyTypeId] = this.AntibodyTypeId;
			}

			if (dtRow.Table.Columns.Contains(ANTIBODYPARAMETER.CanChangeIndicator))
			{
				dtRow[ANTIBODYPARAMETER.CanChangeIndicator] = this.CanChangeIndicator;
			}

			if (dtRow.Table.Columns.Contains(ANTIBODYPARAMETER.CompatibilityPercentage))
			{
				dtRow[ANTIBODYPARAMETER.CompatibilityPercentage] = this.CompatibilityPercentage;
			}

			if (dtRow.Table.Columns.Contains(ANTIBODYPARAMETER.HigherLevelOverrideIndicator))
			{
				dtRow[ANTIBODYPARAMETER.HigherLevelOverrideIndicator] = this.HigherLevelOverrideIndicator;
			}

			return dtRow;
		}

		/// <summary>
		/// Loads properties from DataRow
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{

		}


		#endregion

	}
}
